;; small program: (((2 - (x * x)) mod (2 * (loop (x * x) 2 2))) * (x mod 2))
;; C K K F E C K K F C C J F H K C H F
;; fast program: ((loop (((loop ((x * x) * x) 1 (x * x)) mod (2 * (2 * (2 * (2 + 2))))) + x) (x mod 2) x) - x)
;; K K F K F B K K F J C C C C C D F F F H K D K C H K J K E
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 () Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun h2 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 () Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g2 1))
(assert (= g0 2))
(assert (= h0 2))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (f0 x) (* x x))))
(assert (forall ((x Int)) (= (h2 x) (* x x))))
(assert (forall ((x Int)) (= (g1 x) (modf x 2))))
(assert (forall ((x Int)) (= (f2 x) (* (* x x) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 g2 (h2 x)))))
(assert (forall ((x Int)) (= (small x) (* (modf (- 2 (* x x)) (* 2 v0)) (modf x 2)))))
(assert (forall ((x Int)) (= (f1 x) (+ (modf (v2 x) (* 2 (* 2 (* 2 (+ 2 2))))) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (- (v1 x) x))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
