;; small program: ((loop (2 + (((y * y) div x) + (x div 2))) (2 + x) 1) mod 2)
;; C L L F K G K C G D D C K D B J C H
;; fast program: (((loop ((((((((x div (2 + (2 * (2 + (2 + 2))))) + x) + x) div (1 + (2 + 2))) + x) mod 2) + x) + y) 2 x) + x) mod 2)
;; K C C C C C D D F D G K D K D B C C D D G K D C H K D L D C K J K D C H
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= g1 2))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (g0 x) (+ 2 x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ 2 (+ (divf (* y y) x) (divf x 2))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) 2))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (+ (+ (modf (+ (divf (+ (+ (divf x (+ 2 (* 2 (+ 2 (+ 2 2))))) x) x) (+ 1 (+ 2 2))) x) 2) x) y))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 g1 (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (modf (+ (v1 x) x) 2))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
