;; small program: (loop ((loop (x + x) (y - 2) 1) + (loop 0 (x mod 2) 2)) x 1)
;; K K D L C E B J A K C H C J D K B J
;; fast program: ((if ((x - 2) - 1) <= 0 then (x div (2 + 2)) else 2) + (loop (x + x) (x - 2) 1))
;; K C E B E K C C D G C I K K D K C E B J D
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 () Int)
(declare-fun f3 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun g3 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun h3 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= f2 0))
(assert (= h0 1))
(assert (= h1 1))
(assert (= h3 1))
(assert (= h2 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (f1 x) (+ x x))))
(assert (forall ((x Int)) (= (f3 x) (+ x x))))
(assert (forall ((x Int) (y Int)) (= (g1 x y) (- y 2))))
(assert (forall ((x Int)) (= (g3 x) (- x 2))))
(assert (forall ((x Int)) (= (g2 x) (modf x 2))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y f2))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int) (y Int)) (= (v1 x y) (u1 (g1 x y) h1))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y))))))
(assert (forall ((x Int)) (= (v3 x) (u3 (g3 x) h3))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (v1 x y) (v2 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int)) (= (fast x) (+ (ite (<= (- (- x 2) 1) 0) (divf x (+ 2 2)) 2) (v3 x)))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (u1 x y))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f3 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u3 x y)))))
(assert (=> (forall ((x Int)) (= f2 (f3 x))) (forall ((x Int) (y Int)) (= (u2 x y) (u3 x y)))))
(assert (=> (forall ((x Int)) (= (f1 x) (f3 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u3 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
