;; small program: ((compr (((loop (x * y) x (1 + 2)) div (2 + 2)) mod (2 + x)) (1 + x)) + 2)
;; K L F K B C D J C C D G C K D H B K D M C D
;; fast program: ((compr (((loop (x * y) x (1 + (2 - (x mod 2)))) div (2 + 2)) mod (2 + x)) (1 + x)) + 2)
;; K L F K B C K C H E D J C C D G C K D H B K D M C D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun f3 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun g3 (Int) Int)
(declare-fun h1 () Int)
(declare-fun h3 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun t0 (Int) Int)
(declare-fun t2 (Int) Int)
(declare-fun u0 (Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (g3 x) x)))
(assert (forall ((x Int)) (= (g0 x) (+ 1 x))))
(assert (forall ((x Int)) (= (g2 x) (+ 1 x))))
(assert (= h1 (+ 1 2)))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* x y))))
(assert (forall ((x Int) (y Int)) (= (f3 x y) (* x y))))
(assert (forall ((x Int)) (= (h3 x) (+ 1 (- 2 (modf x 2))))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v3 x) (u3 (g3 x) (h3 x)))))
(assert (forall ((x Int)) (= (f0 x) (modf (divf (v1 x) (+ 2 2)) (+ 2 x)))))
(assert (forall ((x Int)) (= (f2 x) (modf (divf (v3 x) (+ 2 2)) (+ 2 x)))))
(assert (forall ((x Int)) (= (t0 x) (ite (<= (f0 x) 0) x (t0 (+ x 1))))))
(assert (forall ((x Int)) (= (u0 x) (ite (<= x 0) (t0 0) (t0 (+ (u0 (- x 1)) 1))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x)))))
(assert (forall ((x Int)) (= (small x) (+ (v0 x) 2))))
(assert (forall ((x Int)) (= (t2 x) (ite (<= (f2 x) 0) x (t2 (+ x 1))))))
(assert (forall ((x Int)) (= (u2 x) (ite (<= x 0) (t2 0) (t2 (+ (u2 (- x 1)) 1))))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x)))))
(assert (forall ((x Int)) (= (fast x) (+ (v2 x) 2))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (u1 x y))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) (f3 x y))) (forall ((x Int) (y Int)) (= (u1 x y) (u3 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x) (u2 x)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
