;; small program: (loop2 ((1 div x) + y) x (x * x) 1 x)
;; B K G L D K K K F B K N
;; fast program: (loop2 ((y div 2) * y) 0 (x mod 2) 1 (1 + x))
;; L C G L F A K C H B B K D N
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun i0 () Int)
(declare-fun i1 () Int)
(declare-fun j0 (Int) Int)
(declare-fun j1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int Int) Int)
(declare-fun u1 (Int Int Int) Int)
(declare-fun v0 (Int Int Int) Int)
(declare-fun v1 (Int Int Int) Int)
(declare-fun w0 (Int) Int)
(declare-fun w1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g1 0))
(assert (= i0 1))
(assert (= i1 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (j0 x) x)))
(assert (forall ((x Int)) (= (j1 x) (+ 1 x))))
(assert (forall ((x Int)) (= (h0 x) (* x x))))
(assert (forall ((x Int)) (= (h1 x) (modf x 2))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (divf 1 x) y))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* (divf y 2) y))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u0 x y z) (ite (<= x 0) y (f0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v0 x y z) (ite (<= x 0) z (g0 (u0 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w0 x) (u0 (h0 x) i0 (j0 x)))))
(assert (forall ((x Int)) (= (small x) (w0 x))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u1 x y z) (ite (<= x 0) y (f1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v1 x y z) (ite (<= x 0) z g1))))
(assert (forall ((x Int)) (= (w1 x) (u1 (h1 x) i1 (j1 x)))))
(assert (forall ((x Int)) (= (fast x) (w1 x))))
(assert (=> (and (forall ((x Int) (y Int)) (= (f0 x y) (f1 x y))) (forall ((x Int)) (= (g0 x) g1))) (and (forall ((x Int) (y Int) (z Int)) (= (u0 x y z) (u1 x y z))) (forall ((x Int) (y Int) (z Int)) (= (v0 x y z) (v1 x y z))))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
