;; small program: (compr (loop ((loop ((2 + y) * x) 2 2) mod y) x 1) x)
;; C L D K F C C J L H K B J K M
;; fast program: (loop (2 * ((x - y) - y)) ((x - 1) - 2) (1 + x))
;; C K L E L E F K B E C E B K D J
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int Int) Int)
(declare-fun f3 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 () Int)
(declare-fun g3 (Int) Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun h3 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun t0 (Int) Int)
(declare-fun u0 (Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 () Int)
(declare-fun v3 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h1 1))
(assert (= g2 2))
(assert (= h2 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (h3 x) (+ 1 x))))
(assert (forall ((x Int)) (= (g3 x) (- (- x 1) 2))))
(assert (forall ((x Int) (y Int)) (= (f2 x y) (* (+ 2 y) x))))
(assert (forall ((x Int) (y Int)) (= (f3 x y) (* 2 (- (- x y) y)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y) x)))))
(assert (= v2 (u2 g2 h2)))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (modf v2 y))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (f0 x) (v1 x))))
(assert (forall ((x Int)) (= (t0 x) (ite (<= (f0 x) 0) x (t0 (+ x 1))))))
(assert (forall ((x Int)) (= (u0 x) (ite (<= x 0) (t0 0) (t0 (+ (u0 (- x 1)) 1))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x)))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v3 x) (u3 (g3 x) (h3 x)))))
(assert (forall ((x Int)) (= (fast x) (v3 x))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) (f3 x y))) (forall ((x Int) (y Int)) (= (u1 x y) (u3 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f2 x y) (f3 x y))) (forall ((x Int) (y Int)) (= (u2 x y) (u3 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
