;; small program: ((((((loop (x * x) 2 (1 + x)) div (1 + 2)) * 2) * 2) + 2) div (1 + x))
;; K K F C B K D J B C D G C F C F C D B K D G
;; fast program: (((((1 + x) * (loop (x * x) 1 (2 + (x + x)))) div (1 + 2)) - (if (x - 1) <= 0 then 1 else 2)) + 2)
;; B K D K K F B C K K D D J F B C D G K B E B C I E C D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g1 1))
(assert (= g0 2))
(assert (forall ((x Int)) (= (h0 x) (+ 1 x))))
(assert (forall ((x Int)) (= (f0 x) (* x x))))
(assert (forall ((x Int)) (= (f1 x) (* x x))))
(assert (forall ((x Int)) (= (h1 x) (+ 2 (+ x x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 g1 (h1 x)))))
(assert (forall ((x Int)) (= (small x) (divf (+ (* (* (divf (v0 x) (+ 1 2)) 2) 2) 2) (+ 1 x)))))
(assert (forall ((x Int)) (= (fast x) (+ (- (divf (* (+ 1 x) (v1 x)) (+ 1 2)) (ite (<= (- x 1) 0) 1 2)) 2))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
