;; small program: ((loop (((if ((1 + x) mod (1 + (2 + 2))) <= 0 then 1 else x) mod (2 + 2)) - 2) 2 x) + 1)
;; B K D B C C D D H B K I C C D H C E C K J B D
;; fast program: ((loop (((((if ((1 + x) mod (1 + (2 + 2))) <= 0 then 2 else 1) mod (1 + 2)) mod 2) * (1 - (x mod (2 + 2)))) + x) (1 - (x mod 2)) x) - x)
;; B K D B C C D D H C B I B C D H C H B K C C D H E F K D B K C H E K J K E
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (g1 x) (- 1 (modf x 2)))))
(assert (forall ((x Int)) (= (f0 x) (- (modf (ite (<= (modf (+ 1 x) (+ 1 (+ 2 2))) 0) 1 x) (+ 2 2)) 2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (small x) (+ (v0 x) 1))))
(assert (forall ((x Int)) (= (f1 x) (+ (* (modf (modf (ite (<= (modf (+ 1 x) (+ 1 (+ 2 2))) 0) 2 1) (+ 1 2)) 2) (- 1 (modf x (+ 2 2)))) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (- (v1 x) x))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
