;; small program: ((loop (((1 + (2 * (2 * (2 * (2 + y))))) div x) + x) (2 + x) 1) mod 2)
;; B C C C C L D F F F D K G K D C K D B J C H
;; fast program: (((((((((loop (x + x) (x mod (1 + 2)) (1 + (2 + 2))) - 1) + x) div 2) div (2 + x)) mod 2) - x) mod (1 + 2)) mod 2)
;; K K D K B C D H B C C D D J B E K D C G C K D G C H K E B C D H C H
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (forall ((x Int)) (= (f1 x) (+ x x))))
(assert (forall ((x Int)) (= (g0 x) (+ 2 x))))
(assert (= h1 (+ 1 (+ 2 2))))
(assert (forall ((x Int)) (= (g1 x) (modf x (+ 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (divf (+ 1 (* 2 (* 2 (* 2 (+ 2 y))))) x) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) 2))))
(assert (forall ((x Int)) (= (fast x) (modf (modf (- (modf (divf (divf (+ (- (v1 x) 1) x) 2) (+ 2 x)) 2) x) (+ 1 2)) 2))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
