;; small program: (loop ((x * y) div (y - (y div 2))) ((x + x) + x) 1)
;; K L F L L C G E G K K D K D B J
;; fast program: ((loop (2 * ((x - (x div y)) + x)) ((x - (x div 2)) + x) 1) div (1 + (x mod 2)))
;; C K K L G E K D F K K C G E K D B J B K C H D G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= h1 1))
(assert (forall ((x Int)) (= (g0 x) (+ (+ x x) x))))
(assert (forall ((x Int)) (= (g1 x) (+ (- x (divf x 2)) x))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* 2 (+ (- x (divf x y)) x)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (divf (* x y) (- y (divf y 2))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (fast x) (divf (v1 x) (+ 1 (modf x 2))))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
