;; small program: (((loop (2 * ((x - (x div y)) + x)) x (1 + (2 + x))) div 2) div (1 + x))
;; C K K L G E K D F K B C K D D J C G B K D G
;; fast program: ((loop (2 * ((x - (x div y)) + x)) x (1 + (2 + x))) div (2 + (x + x)))
;; C K K L G E K D F K B C K D D J C K K D D G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (h0 x) (+ 1 (+ 2 x)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* 2 (+ (- x (divf x y)) x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int)) (= (fast x) (divf (v0 x) (+ 2 (+ x x))))))
(assert (forall ((x Int)) (= (small x) (divf (divf (v0 x) 2) (+ 1 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f0 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
