;; small program: (loop (((((2 + y) * y) div ((1 + 2) * (x * x))) - 1) + x) x 1)
;; C L D L F B C D K K F F G B E K D K B J
;; fast program: (((2 * ((1 + (2 + 2)) * (2 + (x + x)))) div (loop (x * x) 1 (1 + (2 + (2 + 2))))) + 1)
;; C B C C D D C K K D D F F K K F B B C C C D D D J G B D
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g1 1))
(assert (= h0 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (f1 x) (* x x))))
(assert (= h1 (+ 1 (+ 2 (+ 2 2)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (- (divf (* (+ 2 y) y) (* (+ 1 2) (* x x))) 1) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int)) (= (fast x) (+ (divf (* 2 (* (+ 1 (+ 2 2)) (+ 2 (+ x x)))) v1) 1))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
