;; small program: (loop ((x div 2) * x) 2 ((1 + x) * (2 + x)))
;; K C G K F C B K D C K D F J
;; fast program: (2 * (loop (x * x) 2 (((1 + x) * (2 + x)) div 2)))
;; C K K F C B K D C K D F C G J F
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g0 2))
(assert (= g1 2))
(assert (forall ((x Int)) (= (f1 x) (* x x))))
(assert (forall ((x Int)) (= (f0 x) (* (divf x 2) x))))
(assert (forall ((x Int)) (= (h0 x) (* (+ 1 x) (+ 2 x)))))
(assert (forall ((x Int)) (= (h1 x) (divf (* (+ 1 x) (+ 2 x)) 2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 g1 (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (* 2 (v1 x)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
