;; small program: ((loop (((if (y mod (1 + 2)) <= 0 then x else 1) * 2) + 2) (x - 1) 0) div 2)
;; L B C D H K B I C F C D K B E A J C G
;; fast program: ((1 - x) mod ((loop (y * y) (((x - 1) - 1) mod (1 + 2)) 1) + x))
;; B K E L L F K B E B E B C D H B J K D H
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 0))
(assert (= h1 1))
(assert (forall ((x Int)) (= (g0 x) (- x 1))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* y y))))
(assert (forall ((x Int)) (= (g1 x) (modf (- (- x 1) 1) (+ 1 2)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (* (ite (<= (modf y (+ 1 2)) 0) x 1) 2) 2))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (divf (v0 x) 2))))
(assert (forall ((x Int)) (= (fast x) (modf (- 1 x) (+ (v1 x) x)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
