;; small program: ((((loop2 (x - y) (y div 2) x x x) + x) * (loop (0 - x) x 1)) + x)
;; K L E L C G K K K N K D A K E K B J F K D
;; fast program: (((loop2 (x - y) (y div 2) (2 + (2 + 2)) x (x div 2)) * (loop (0 - 1) (x mod 2) 1)) + x)
;; K L E L C G C C C D D K K C G N A B E K C H B J F K D
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int Int) Int)
(declare-fun f3 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int Int) Int)
(declare-fun g3 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun h3 () Int)
(declare-fun i0 (Int) Int)
(declare-fun i2 (Int) Int)
(declare-fun j0 (Int) Int)
(declare-fun j2 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun v0 (Int Int Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int Int Int) Int)
(declare-fun v3 (Int) Int)
(declare-fun w0 (Int) Int)
(declare-fun w2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h1 1))
(assert (= h3 1))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (i0 x) x)))
(assert (forall ((x Int)) (= (i2 x) x)))
(assert (forall ((x Int)) (= (j0 x) x)))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (- x y))))
(assert (forall ((x Int)) (= (f1 x) (- 0 x))))
(assert (forall ((x Int) (y Int)) (= (f2 x y) (- x y))))
(assert (= f3 (- 0 1)))
(assert (forall ((x Int) (y Int)) (= (g0 x y) (divf y 2))))
(assert (forall ((x Int) (y Int)) (= (g2 x y) (divf y 2))))
(assert (forall ((x Int)) (= (j2 x) (divf x 2))))
(assert (forall ((x Int)) (= (g3 x) (modf x 2))))
(assert (= h2 (+ 2 (+ 2 2))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y f3))))
(assert (forall ((x Int)) (= (v3 x) (u3 (g3 x) h3))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u0 x y z) (ite (<= x 0) y (f0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v0 x y z) (ite (<= x 0) z (g0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w0 x) (u0 (h0 x) (i0 x) (j0 x)))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u2 x y z) (ite (<= x 0) y (f2 (u2 (- x 1) y z) (v2 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v2 x y z) (ite (<= x 0) z (g2 (u2 (- x 1) y z) (v2 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w2 x) (u2 h2 (i2 x) (j2 x)))))
(assert (forall ((x Int)) (= (small x) (+ (* (+ (w0 x) x) (v1 x)) x))))
(assert (forall ((x Int)) (= (fast x) (+ (* (w2 x) (v3 x)) x))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u2 x y z) (u0 x y z))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v2 x y z) (v0 x y z))))
(assert (=> (forall ((x Int)) (= (f1 x) f3)) (forall ((x Int) (y Int)) (= (u1 x y) (u3 x y)))))
(assert (=> (and (forall ((x Int) (y Int)) (= (f0 x y) (f2 x y))) (forall ((x Int) (y Int)) (= (g0 x y) (g2 x y)))) (and (forall ((x Int) (y Int) (z Int)) (= (u0 x y z) (u2 x y z))) (forall ((x Int) (y Int) (z Int)) (= (v0 x y z) (v2 x y z))))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
