;; small program: (loop (((((loop (((y + y) div (x * x)) + x) (x - (x div 2)) 2) + x) mod 2) - (x mod 2)) - x) 2 x)
;; L L D K K F G K D K K C G E C J K D C H K C H E K E C K J
;; fast program: (((((((((loop (((y + y) div (x * x)) + x) (x - (x div 2)) 2) + x) mod 2) * 2) - 1) mod (1 + 2)) - 1) + x) - (1 - (x mod 2)))
;; L L D K K F G K D K K C G E C J K D C H C F B E B C D H B E K D B K C H E E
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (= h1 2))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (g1 x) (- x (divf x 2)))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (+ (divf (+ y y) (* x x)) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (f0 x) (- (- (modf (+ (v1 x) x) 2) (modf x 2)) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int)) (= (fast x) (- (+ (- (modf (- (* (modf (+ (v1 x) x) 2) 2) 1) (+ 1 2)) 1) x) (- 1 (modf x 2))))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u1 x y))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u1 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
