;; small program: (((loop ((2 * ((2 * (x * y)) - x)) div (2 + y)) x (1 + 2)) * x) div 2)
;; C C K L F F K E F C L D G K B C D J K F C G
;; fast program: ((loop (2 * ((x - (x div y)) + x)) x ((x + x) + x)) div ((1 + x) * (2 + x)))
;; C K K L G E K D F K K K D K D J B K D C K D F G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (= h0 (+ 1 2)))
(assert (forall ((x Int)) (= (h1 x) (+ (+ x x) x))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* 2 (+ (- x (divf x y)) x)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (divf (* 2 (- (* 2 (* x y)) x)) (+ 2 y)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (divf (* (v0 x) x) 2))))
(assert (forall ((x Int)) (= (fast x) (divf (v1 x) (* (+ 1 x) (+ 2 x))))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
