;; small program: ((loop ((((x + x) + x) div y) + x) x (loop (x + y) x 2)) div 2)
;; K K D K D L G K D K K L D K C J J C G
;; fast program: (((((loop ((x * x) * x) 1 (2 + x)) - x) div (1 + 2)) * (2 + (2 + ((x * x) + x)))) div (2 * (2 + 2)))
;; K K F K F B C K D J K E B C D G C C K K F K D D D F C C C D F G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun h2 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g2 1))
(assert (= h1 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (+ x y))))
(assert (forall ((x Int)) (= (h2 x) (+ 2 x))))
(assert (forall ((x Int)) (= (f2 x) (* (* x x) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (h0 x) (v1 x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (divf (+ (+ x x) x) y) x))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 g2 (h2 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int)) (= (small x) (divf (v0 x) 2))))
(assert (forall ((x Int)) (= (fast x) (divf (* (divf (- (v2 x) x) (+ 1 2)) (+ 2 (+ 2 (+ (* x x) x)))) (* 2 (+ 2 2))))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) (f2 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
