;; small program: ((((x + x) div (1 + (loop 0 (x mod 2) 2))) + 1) + (x mod 2))
;; K K D B A K C H C J D G B D K C H D
;; fast program: ((loop ((x div (1 + 2)) - 1) (1 - (x mod 2)) (x + x)) + 2)
;; K B C D G B E B K C H E K K D J C D
(set-logic UFNIA)
(declare-fun f0 () Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= f0 0))
(assert (= h0 2))
(assert (forall ((x Int)) (= (h1 x) (+ x x))))
(assert (forall ((x Int)) (= (g0 x) (modf x 2))))
(assert (forall ((x Int)) (= (g1 x) (- 1 (modf x 2)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y f0))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (f1 x) (- (divf x (+ 1 2)) 1))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (+ (v1 x) 2))))
(assert (forall ((x Int)) (= (small x) (+ (+ (divf (+ x x) (+ 1 (v0 x))) 1) (modf x 2)))))
(assert (=> (forall ((x Int)) (= f0 (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
