;; small program: ((loop (((loop (2 + (2 + (2 + (x * x)))) 2 2) mod (1 + x)) + x) 2 x) mod 2)
;; C C C K K F D D D C C J B K D H K D C K J C H
;; fast program: ((if (((loop ((2 * (2 + (2 * (2 + 2)))) * (1 + x)) 2 2) - 1) mod (1 + x)) <= 0 then 1 else 2) - 1)
;; C C C C C D F D F B K D F C C J B E B K D H B C I B E
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun g2 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(declare-fun v2 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (= g1 2))
(assert (= g2 2))
(assert (= h1 2))
(assert (= h2 2))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (f1 x) (+ 2 (+ 2 (+ 2 (* x x)))))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int)) (= (f2 x) (* (* 2 (+ 2 (* 2 (+ 2 2)))) (+ 1 x)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (= v2 (u2 g2 h2)))
(assert (forall ((x Int)) (= (f0 x) (+ (modf v1 (+ 1 x)) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) 2))))
(assert (forall ((x Int)) (= (fast x) (- (ite (<= (modf (- v2 1) (+ 1 x)) 0) 1 2) 1))))
(assert (=> (forall ((x Int)) (= (f0 x) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (=> (forall ((x Int)) (= (f1 x) (f2 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
