;; small program: (1 + (loop (((2 mod x) + y) * y) (x + x) x))
;; B C K H L D L F K K D K J D
;; fast program: (1 + (2 * (2 * (((loop 0 (2 - x) x) * x) + x))))
;; B C C A C K E K J K F K D F F D
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= f1 0))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (g0 x) (+ x x))))
(assert (forall ((x Int)) (= (g1 x) (- 2 x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* (+ (modf 2 x) y) y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int)) (= (small x) (+ 1 (v0 x)))))
(assert (forall ((x Int)) (= (fast x) (+ 1 (* 2 (* 2 (+ (* (v1 x) x) x)))))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) f1)) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
