;; small program: ((((if (loop ((x - 1) mod y) x 0) <= 0 then (1 + x) else 0) * 2) + 1) + x)
;; K B E L H K A J B K D A I C F B D K D
;; fast program: (((if ((loop ((x * x) * x) 1 (2 + 2)) mod (1 + x)) <= 0 then 2 else 0) + 1) * (1 + x))
;; K K F K F B C C D J B K D H C A I B D B K D F
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 0))
(assert (= g1 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (= h1 (+ 2 2)))
(assert (forall ((x Int)) (= (f1 x) (* (* x x) x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (modf (- x 1) y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int)) (= (small x) (+ (+ (* (ite (<= (v0 x) 0) (+ 1 x) 0) 2) 1) x))))
(assert (forall ((x Int)) (= (fast x) (* (+ (ite (<= (modf v1 (+ 1 x)) 0) 2 0) 1) (+ 1 x)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
