;; small program: ((loop ((1 + x) mod (1 + (2 * (2 + 2)))) (x mod (1 + (2 * (2 * (2 + (2 + 2)))))) 2) mod 2)
;; B K D B C C C D F D H K B C C C C C D D F F D H C J C H
;; fast program: ((((loop (x + x) ((x mod (1 + (2 * (2 * (2 + (2 + 2)))))) mod (1 + (2 * (2 + 2)))) 1) mod (loop (1 + ((2 + x) * x)) 2 2)) - 1) mod (1 + 2))
;; K K D K B C C C C C D D F F D H B C C C D F D H B J B C K D K F D C C J H B E B C D H
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h1 1))
(assert (= g2 2))
(assert (= h0 2))
(assert (= h2 2))
(assert (forall ((x Int)) (= (f1 x) (+ x x))))
(assert (forall ((x Int)) (= (f2 x) (+ 1 (* (+ 2 x) x)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (= v2 (u2 g2 h2)))
(assert (forall ((x Int)) (= (f0 x) (modf (+ 1 x) (+ 1 (* 2 (+ 2 2)))))))
(assert (forall ((x Int)) (= (g0 x) (modf x (+ 1 (* 2 (* 2 (+ 2 (+ 2 2)))))))))
(assert (forall ((x Int)) (= (g1 x) (modf (modf x (+ 1 (* 2 (* 2 (+ 2 (+ 2 2)))))) (+ 1 (* 2 (+ 2 2)))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) 2))))
(assert (forall ((x Int)) (= (fast x) (modf (- (modf (v1 x) v2) 1) (+ 1 2)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
