;; small program: ((if ((if x <= 0 then 1 else x) mod (1 + (2 + 2))) <= 0 then 2 else 1) * (loop (0 - x) x 1))
;; K B K I B C C D D H C B I A K E K B J F
;; fast program: ((if (x mod (1 + (2 + 2))) <= 0 then (if x <= 0 then 1 else 2) else 1) * (loop (0 - x) (x mod 2) 1))
;; K B C C D D H K B C I B I A K E K C H B J F
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= h1 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (f0 x) (- 0 x))))
(assert (forall ((x Int)) (= (f1 x) (- 0 x))))
(assert (forall ((x Int)) (= (g1 x) (modf x 2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (small x) (* (ite (<= (modf (ite (<= x 0) 1 x) (+ 1 (+ 2 2))) 0) 2 1) (v0 x)))))
(assert (forall ((x Int)) (= (fast x) (* (ite (<= (modf x (+ 1 (+ 2 2))) 0) (ite (<= x 0) 1 2) 1) (v1 x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
