;; small program: ((loop (x div (loop 1 (((x * x) + x) mod (2 + 2)) (2 + 2))) x x) mod 2)
;; K B K K F K D C C D H C C D J G K K J C H
;; fast program: ((loop (x div (loop 1 (2 - ((2 - x) mod (2 + 2))) (2 + 2))) (1 + 2) x) mod 2)
;; K B C C K E C C D H E C C D J G B C D K J C H
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 () Int)
(declare-fun f2 (Int) Int)
(declare-fun f3 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 () Int)
(declare-fun g3 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun h2 (Int) Int)
(declare-fun h3 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= f1 1))
(assert (= f3 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (h2 x) x)))
(assert (= g2 (+ 1 2)))
(assert (= h1 (+ 2 2)))
(assert (= h3 (+ 2 2)))
(assert (forall ((x Int)) (= (g3 x) (- 2 (modf (- 2 x) (+ 2 2))))))
(assert (forall ((x Int)) (= (g1 x) (modf (+ (* x x) x) (+ 2 2)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y f3))))
(assert (forall ((x Int)) (= (v3 x) (u3 (g3 x) h3))))
(assert (forall ((x Int)) (= (f0 x) (divf x (v1 x)))))
(assert (forall ((x Int)) (= (f2 x) (divf x (v3 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) 2))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 g2 (h2 x)))))
(assert (forall ((x Int)) (= (fast x) (modf (v2 x) 2))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (u1 x y))))
(assert (=> (forall ((x Int)) (= (f0 x) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) f3)) (forall ((x Int) (y Int)) (= (u0 x y) (u3 x y)))))
(assert (=> (forall ((x Int)) (= f1 (f2 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u2 x y)))))
(assert (=> (= f1 f3) (forall ((x Int) (y Int)) (= (u1 x y) (u3 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
