;; small program: ((loop (((((y * y) * x) + x) div ((2 * (2 + 2)) + x)) + x) 2 x) + 2)
;; L L F K F K D C C C D F K D G K D C K J C D
;; fast program: (compr ((((2 * (2 * (loop ((x * x) + x) 2 2))) mod (1 + x)) + 2) - x) x)
;; C C K K F K D C C J F F B K D H C D K E K M
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun t1 (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (= g2 2))
(assert (= h2 2))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (f2 x) (+ (* x x) x))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (= v2 (u2 g2 h2)))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (divf (+ (* (* y y) x) x) (+ (* 2 (+ 2 2)) x)) x))))
(assert (forall ((x Int)) (= (f1 x) (- (+ (modf (* 2 (* 2 v2)) (+ 1 x)) 2) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (small x) (+ (v0 x) 2))))
(assert (forall ((x Int)) (= (t1 x) (ite (<= (f1 x) 0) x (t1 (+ x 1))))))
(assert (forall ((x Int)) (= (u1 x) (ite (<= x 0) (t1 0) (t1 (+ (u1 (- x 1)) 1))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x)))))
(assert (forall ((x Int)) (= (fast x) (v1 x))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
