;; small program: (loop ((loop ((2 + y) * x) 2 (2 mod y)) * y) x 1)
;; C L D K F C C L H J L F K B J
;; fast program: (((loop (1 + (loop (x * y) (2 + 2) 1)) (x - 2) 1) * (if x <= 0 then 1 else x)) - x)
;; B K L F C C D B J D K C E B J K B K I F K E
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 () Int)
(declare-fun f3 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun g2 (Int) Int)
(declare-fun g3 () Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int Int) Int)
(declare-fun h2 () Int)
(declare-fun h3 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= h2 1))
(assert (= h3 1))
(assert (= g1 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (= g3 (+ 2 2)))
(assert (forall ((x Int)) (= (g2 x) (- x 2))))
(assert (forall ((x Int) (y Int)) (= (f3 x y) (* x y))))
(assert (forall ((x Int) (y Int)) (= (h1 x y) (modf 2 y))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* (+ 2 y) x))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y) x)))))
(assert (= v3 (u3 g3 h3)))
(assert (= f2 (+ 1 v3)))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int) (y Int)) (= (v1 x y) (u1 g1 (h1 x y)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* (v1 x y) y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y f2))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int)) (= (fast x) (- (* (v2 x) (ite (<= x 0) 1 x)) x))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) f2)) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f3 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u3 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) f2)) (forall ((x Int) (y Int)) (= (u1 x y) (u2 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) (f3 x y))) (forall ((x Int) (y Int)) (= (u1 x y) (u3 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
