;; small program: (((x div 2) * (loop (1 + (x + x)) 2 2)) div (((x + x) + x) - 2))
;; K C G B K K D D C C J F K K D K D C E G
;; fast program: ((if ((loop (1 + (2 * (2 + 2))) ((1 + x) mod 2) 2) - x) <= 0 then 1 else 2) mod (1 + x))
;; B C C C D F D B K D C H C J K E B C I B K D H
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 () Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (= h0 2))
(assert (= h1 2))
(assert (forall ((x Int)) (= (f0 x) (+ 1 (+ x x)))))
(assert (forall ((x Int)) (= (g1 x) (modf (+ 1 x) 2))))
(assert (= f1 (+ 1 (* 2 (+ 2 2)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (small x) (divf (* (divf x 2) v0) (- (+ (+ x x) x) 2)))))
(assert (forall ((x Int)) (= (fast x) (modf (ite (<= (- (v1 x) x) 0) 1 2) (+ 1 x)))))
(assert (=> (forall ((x Int)) (= (f0 x) f1)) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
