;; small program: ((loop ((((2 + y) * y) div (2 + x)) + (x div 2)) (2 + x) 0) mod 2)
;; C L D L F C K D G K C G D C K D A J C H
;; fast program: (if ((((loop ((1 + ((x div (2 + 2)) + x)) div (1 + 2)) 2 x) + 1) + x) mod (2 + 2)) <= 0 then 1 else 0)
;; B K C C D G K D D B C D G C K J B D K D C C D H B A I
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 0))
(assert (= g1 2))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (g0 x) (+ 2 x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (divf (* (+ 2 y) y) (+ 2 x)) (divf x 2)))))
(assert (forall ((x Int)) (= (f1 x) (divf (+ 1 (+ (divf x (+ 2 2)) x)) (+ 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 g1 (h1 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) 2))))
(assert (forall ((x Int)) (= (fast x) (ite (<= (modf (+ (+ (v1 x) 1) x) (+ 2 2)) 0) 1 0))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
