;; small program: ((loop (((x - (1 mod x)) + x) + x) x 1) - (x mod 2))
;; K B K H E K D K D K B J K C H E
;; fast program: (((((1 + (2 + 2)) * (loop2 (x * y) y (x div 2) (loop (1 + 2) (x mod 2) 1) (1 + (2 * (2 + 2))))) div (2 + (2 + 2))) - (x mod 2)) + 1)
;; B C C D D K L F L K C G B C D K C H B J B C C C D F D N F C C C D D G K C H E B D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun h2 () Int)
(declare-fun i1 (Int) Int)
(declare-fun j1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int Int Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun w1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= h2 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int) (y Int)) (= (g1 x y) y)))
(assert (= f2 (+ 1 2)))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* x y))))
(assert (forall ((x Int)) (= (h1 x) (divf x 2))))
(assert (forall ((x Int)) (= (g2 x) (modf x 2))))
(assert (= j1 (+ 1 (* 2 (+ 2 2)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y f2))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int)) (= (i1 x) (v2 x))))
(assert (forall ((x Int)) (= (f0 x) (+ (+ (- x (modf 1 x)) x) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (- (v0 x) (modf x 2)))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u1 x y z) (ite (<= x 0) y (f1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v1 x y z) (ite (<= x 0) z (g1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w1 x) (u1 (h1 x) (i1 x) j1))))
(assert (forall ((x Int)) (= (fast x) (+ (- (divf (* (+ 1 (+ 2 2)) (w1 x)) (+ 2 (+ 2 2))) (modf x 2)) 1))))
(assert (=> (forall ((x Int)) (= (f0 x) f2)) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
