;; small program: (if x <= 0 then 1 else (loop (2 * (x * y)) x 2))
;; K B C K L F F K C J I
;; fast program: ((if x <= 0 then 1 else (loop (x + x) x 2)) * (loop (x * y) x 1))
;; K B K K D K C J I K L F K B J F
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(assert (= h2 1))
(assert (= h0 2))
(assert (= h1 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (g2 x) x)))
(assert (forall ((x Int)) (= (f1 x) (+ x x))))
(assert (forall ((x Int) (y Int)) (= (f2 x y) (* x y))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* 2 (* x y)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (ite (<= x 0) 1 (v0 x)))))
(assert (forall ((x Int)) (= (fast x) (* (ite (<= x 0) 1 (v1 x)) (v2 x)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f2 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
