;; small program: (((1 + (loop ((x * x) + x) 2 2)) * (1 + x)) div (1 + (loop ((2 + y) * x) 2 2)))
;; B K K F K D C C J D B K D F B C L D K F C C J D G
;; fast program: ((((2 * ((1 + 2) * ((1 + 2) * (1 + x)))) div (loop (x * x) 1 (1 + (2 + 2)))) + 1) + x)
;; C B C D B C D B K D F F F K K F B B C C D D J G B D K D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun g2 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 () Int)
(declare-fun v1 () Int)
(declare-fun v2 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g2 1))
(assert (= g0 2))
(assert (= g1 2))
(assert (= h0 2))
(assert (= h1 2))
(assert (forall ((x Int)) (= (f2 x) (* x x))))
(assert (forall ((x Int)) (= (f0 x) (+ (* x x) x))))
(assert (= h2 (+ 1 (+ 2 2))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* (+ 2 y) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (= v2 (u2 g2 h2)))
(assert (forall ((x Int)) (= (small x) (divf (* (+ 1 v0) (+ 1 x)) (+ 1 v1)))))
(assert (forall ((x Int)) (= (fast x) (+ (+ (divf (* 2 (* (+ 1 2) (* (+ 1 2) (+ 1 x)))) v2) 1) x))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) (f2 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u2 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
