;; small program: (((((loop (1 + ((x * x) * x)) 2 2) * (1 + x)) - (x div 2)) + x) div 2)
;; B K K F K F D C C J B K D F K C G E K D C G
;; fast program: (((1 + (2 + (2 * (loop ((x * x) * x) 1 (1 + (2 * (2 + 2))))))) * (1 + x)) div (2 + 2))
;; B C C K K F K F B B C C C D F D J F D D B K D F C C D G
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 () Int)
(declare-fun v1 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g1 1))
(assert (= g0 2))
(assert (= h0 2))
(assert (forall ((x Int)) (= (f1 x) (* (* x x) x))))
(assert (forall ((x Int)) (= (f0 x) (+ 1 (* (* x x) x)))))
(assert (= h1 (+ 1 (* 2 (+ 2 2)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int)) (= (small x) (divf (+ (- (* v0 (+ 1 x)) (divf x 2)) x) 2))))
(assert (forall ((x Int)) (= (fast x) (divf (* (+ 1 (+ 2 (* 2 v1))) (+ 1 x)) (+ 2 2)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
