;; small program: ((loop (((x * x) * x) - x) 1 (2 + x)) div (1 + (x mod 2)))
;; K K F K F K E B C K D J B K C H D G
;; fast program: ((1 + (loop (x div 2) (x mod 2) (2 + x))) * ((1 + x) * (2 + x)))
;; B K C G K C H C K D J D B K D C K D F F
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 1))
(assert (forall ((x Int)) (= (h0 x) (+ 2 x))))
(assert (forall ((x Int)) (= (h1 x) (+ 2 x))))
(assert (forall ((x Int)) (= (f1 x) (divf x 2))))
(assert (forall ((x Int)) (= (g1 x) (modf x 2))))
(assert (forall ((x Int)) (= (f0 x) (- (* (* x x) x) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (small x) (divf (v0 x) (+ 1 (modf x 2))))))
(assert (forall ((x Int)) (= (fast x) (* (+ 1 (v1 x)) (* (+ 1 x) (+ 2 x))))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
