;; small program: ((((x - 1) div ((loop ((y div (x * x)) + x) x 1) + ((0 - x) mod 2))) + x) mod 2)
;; K B E L K K F G K D K B J A K E C H D G K D C H
;; fast program: (((loop2 ((loop (x + y) x y) div x) y (1 + 2) (2 + 2) ((x div 2) - (loop (0 - 1) (x mod 2) 1))) + 1) mod 2)
;; K L D K L J K G L B C D C C D K C G A B E K C H B J E N B D C H
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int Int) Int)
(declare-fun f3 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun g3 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 (Int Int) Int)
(declare-fun h3 () Int)
(declare-fun i1 () Int)
(declare-fun j1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int Int Int) Int)
(declare-fun v2 (Int Int) Int)
(declare-fun v3 (Int) Int)
(declare-fun w1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= h3 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g2 x) x)))
(assert (forall ((x Int) (y Int)) (= (g1 x y) y)))
(assert (forall ((x Int) (y Int)) (= (h2 x y) y)))
(assert (forall ((x Int) (y Int)) (= (f2 x y) (+ x y))))
(assert (= h1 (+ 1 2)))
(assert (= i1 (+ 2 2)))
(assert (= f3 (- 0 1)))
(assert (forall ((x Int)) (= (g3 x) (modf x 2))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y) x)))))
(assert (forall ((x Int) (y Int)) (= (v2 x y) (u2 (g2 x) (h2 x y)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (divf y (* x x)) x))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (divf (v2 x y) x))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y f3))))
(assert (forall ((x Int)) (= (v3 x) (u3 (g3 x) h3))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (j1 x) (- (divf x 2) (v3 x)))))
(assert (forall ((x Int)) (= (small x) (modf (+ (divf (- x 1) (+ (v0 x) (modf (- 0 x) 2))) x) 2))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u1 x y z) (ite (<= x 0) y (f1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v1 x y z) (ite (<= x 0) z (g1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w1 x) (u1 h1 i1 (j1 x)))))
(assert (forall ((x Int)) (= (fast x) (modf (+ (w1 x) 1) 2))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) f3)) (forall ((x Int) (y Int)) (= (u0 x y) (u3 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f2 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
