;; small program: (((((loop (2 * ((2 * (x + x)) + x)) 2 x) - 1) + x) mod (2 + (1 + x))) + 2)
;; C C K K D F K D F C K J B E K D C B K D D H C D
;; fast program: ((((((1 + (loop (x * x) 2 2)) * (x * x)) - 1) * (1 + x)) mod ((1 + x) + 2)) + 2)
;; B K K F C C J D K K F F B E B K D F B K D C D H C D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (= g1 2))
(assert (= h1 2))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (f1 x) (* x x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int)) (= (f0 x) (* 2 (+ (* 2 (+ x x)) x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (small x) (+ (modf (+ (- (v0 x) 1) x) (+ 2 (+ 1 x))) 2))))
(assert (forall ((x Int)) (= (fast x) (+ (modf (* (- (* (+ 1 v1) (* x x)) 1) (+ 1 x)) (+ (+ 1 x) 2)) 2))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
