;; small program: ((1 + (if (x mod (1 + 2)) <= 0 then (2 + (loop (x * x) 2 2)) else 1)) * (if x <= 0 then 1 else 2))
;; B K B C D H C K K F C C J D B I D K B C I F
;; fast program: ((loop (1 + (2 + (2 * (2 * (2 + 2))))) (1 - (x mod (1 + 2))) 2) * (if x <= 0 then 1 else 2))
;; B C C C C C D F F D D B K B C D H E C J K B C I F
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 () Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (= h0 2))
(assert (= h1 2))
(assert (forall ((x Int)) (= (f0 x) (* x x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int)) (= (g1 x) (- 1 (modf x (+ 1 2))))))
(assert (= f1 (+ 1 (+ 2 (* 2 (* 2 (+ 2 2)))))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (small x) (* (+ 1 (ite (<= (modf x (+ 1 2)) 0) (+ 2 v0) 1)) (ite (<= x 0) 1 2)))))
(assert (forall ((x Int)) (= (fast x) (* (v1 x) (ite (<= x 0) 1 2)))))
(assert (=> (forall ((x Int)) (= (f0 x) f1)) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
