;; small program: ((if x <= 0 then 2 else (loop 1 (x mod 2) (2 + 2))) * (loop (1 + (x + x)) 2 2))
;; K C B K C H C C D J I B K K D D C C J F
;; fast program: ((1 + (2 + (2 * (2 + 2)))) * (if x <= 0 then 2 else (loop 1 (x mod 2) (2 + 2))))
;; B C C C C D F D D K C B K C H C C D J I F
(set-logic UFNIA)
(declare-fun f0 () Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= f0 1))
(assert (= g1 2))
(assert (= h1 2))
(assert (= h0 (+ 2 2)))
(assert (forall ((x Int)) (= (g0 x) (modf x 2))))
(assert (forall ((x Int)) (= (f1 x) (+ 1 (+ x x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y f0))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int)) (= (small x) (* (ite (<= x 0) 2 (v0 x)) v1))))
(assert (forall ((x Int)) (= (fast x) (* (+ 1 (+ 2 (* 2 (+ 2 2)))) (ite (<= x 0) 2 (v0 x))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (=> (forall ((x Int)) (= (f1 x) f0)) (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y)))))
(assert (=> (= f0 f0) (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
