;; small program: (loop ((loop y (y mod (1 + 2)) (2 + 2)) + x) x 2)
;; L L B C D H C C D J K D K C J
;; fast program: ((((x div (1 + 2)) + (loop 1 (x mod (1 + 2)) 2)) + x) + x)
;; K B C D G B K B C D H C J D K D K D
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int Int) Int)
(declare-fun v2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= f2 1))
(assert (= h0 2))
(assert (= h2 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int) (y Int)) (= (f1 x y) y)))
(assert (= h1 (+ 2 2)))
(assert (forall ((x Int) (y Int)) (= (g1 x y) (modf y (+ 1 2)))))
(assert (forall ((x Int)) (= (g2 x) (modf x (+ 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y f2))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int) (y Int)) (= (v1 x y) (u1 (g1 x y) h1))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (v1 x y) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int)) (= (fast x) (+ (+ (+ (divf x (+ 1 2)) (v2 x)) x) x))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) f2)) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) f2)) (forall ((x Int) (y Int)) (= (u1 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
