;; small program: ((if (x mod 2) <= 0 then (loop ((x * x) + y) 2 2) else 1) + (x div 2))
;; K C H K K F L D C C J B I K C G D
;; fast program: ((loop (loop ((x * x) * x) 1 (1 + 2)) (1 - (x mod 2)) 1) + (x div 2))
;; K K F K F B B C D J B K C H E B J K C G D
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 () Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 () Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g2 1))
(assert (= h1 1))
(assert (= g0 2))
(assert (= h0 2))
(assert (= h2 (+ 1 2)))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (* x x) y))))
(assert (forall ((x Int)) (= (g1 x) (- 1 (modf x 2)))))
(assert (forall ((x Int)) (= (f2 x) (* (* x x) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (= v2 (u2 g2 h2)))
(assert (= f1 v2))
(assert (forall ((x Int)) (= (small x) (+ (ite (<= (modf x 2) 0) v0 1) (divf x 2)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (fast x) (+ (v1 x) (divf x 2)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) f1)) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
