;; small program: ((loop (x div (if (x mod (1 + 2)) <= 0 then (1 + 2) else 1)) x (1 + x)) mod (1 + 2))
;; K K B C D H B C D B I G K B K D J B C D H
;; fast program: ((((((loop (if (x mod (1 + 2)) <= 0 then (x div (1 + 2)) else x) (x mod (1 + 2)) (1 + x)) mod (1 + 2)) + x) mod (1 + x)) mod 2) + 1)
;; K B C D H K B C D G K I K B C D H B K D J B C D H K D B K D H C H B D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (h0 x) (+ 1 x))))
(assert (forall ((x Int)) (= (h1 x) (+ 1 x))))
(assert (forall ((x Int)) (= (g1 x) (modf x (+ 1 2)))))
(assert (forall ((x Int)) (= (f0 x) (divf x (ite (<= (modf x (+ 1 2)) 0) (+ 1 2) 1)))))
(assert (forall ((x Int)) (= (f1 x) (ite (<= (modf x (+ 1 2)) 0) (divf x (+ 1 2)) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) (+ 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (+ (modf (modf (+ (modf (v1 x) (+ 1 2)) x) (+ 1 x)) 2) 1))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
