;; small program: (loop (1 + ((x * y) * y)) x 1)
;; B K L F L F D K B J
;; fast program: (((x * x) * (loop (1 + ((y * y) * x)) (x - 1) 1)) + 1)
;; K K F B L L F K F D K B E B J F B D
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(assert (= h0 1))
(assert (= h1 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) (- x 1))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ 1 (* (* x y) y)))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (+ 1 (* (* y y) x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (fast x) (+ (* (* x x) (v1 x)) 1))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
