;; small program: (((loop (((((x div (1 + 2)) mod (2 + 2)) div 2) + 1) + x) x 0) + 1) + (x * x))
;; K B C D G C C D H C G B D K D K A J B D K K F D
;; fast program: (((compr ((loop ((loop (x div (1 + 2)) (x mod 2) x) div 2) (x mod 2) x) mod 2) x) + 1) + (x * x))
;; K B C D G K C H K J C G K C H K J C H K M B D K K F D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun f3 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun g3 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h2 (Int) Int)
(declare-fun h3 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun t1 (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 0))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (h2 x) x)))
(assert (forall ((x Int)) (= (h3 x) x)))
(assert (forall ((x Int)) (= (g2 x) (modf x 2))))
(assert (forall ((x Int)) (= (g3 x) (modf x 2))))
(assert (forall ((x Int)) (= (f3 x) (divf x (+ 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y))))))
(assert (forall ((x Int)) (= (v3 x) (u3 (g3 x) (h3 x)))))
(assert (forall ((x Int)) (= (f2 x) (divf (v3 x) 2))))
(assert (forall ((x Int)) (= (f0 x) (+ (+ (divf (modf (divf x (+ 1 2)) (+ 2 2)) 2) 1) x))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) (h2 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (f1 x) (modf (v2 x) 2))))
(assert (forall ((x Int)) (= (t1 x) (ite (<= (f1 x) 0) x (t1 (+ x 1))))))
(assert (forall ((x Int)) (= (u1 x) (ite (<= x 0) (t1 0) (t1 (+ (u1 (- x 1)) 1))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x)))))
(assert (forall ((x Int)) (= (small x) (+ (+ (v0 x) 1) (* x x)))))
(assert (forall ((x Int)) (= (fast x) (+ (+ (v1 x) 1) (* x x)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f3 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u3 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
