;; small program: ((1 + (loop ((2 + x) mod y) (1 + x) 1)) mod (1 + 2))
;; B C K D L H B K D B J D B C D H
;; fast program: (((((((loop (x div (loop 1 (2 - x) (2 + 2))) (1 + 2) (1 + x)) + 1) mod 2) + 1) + x) + x) mod (1 + 2))
;; K B C K E C C D J G B C D B K D J B D C H B D K D K D B C D H
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun g2 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= f2 1))
(assert (= h0 1))
(assert (forall ((x Int)) (= (g0 x) (+ 1 x))))
(assert (= g1 (+ 1 2)))
(assert (forall ((x Int)) (= (h1 x) (+ 1 x))))
(assert (= h2 (+ 2 2)))
(assert (forall ((x Int)) (= (g2 x) (- 2 x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (modf (+ 2 x) y))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y f2))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int)) (= (f1 x) (divf x (v2 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (modf (+ 1 (v0 x)) (+ 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 g1 (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (modf (+ (+ (+ (modf (+ (v1 x) 1) 2) 1) x) x) (+ 1 2)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) f2)) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
