;; small program: (if ((loop (2 * ((x + x) + x)) x 1) mod (1 + x)) <= 0 then (1 + x) else 0)
;; C K K D K D F K B J B K D H B K D A I
;; fast program: (if ((loop (x * x) 2 (2 * (2 + (2 + 2)))) mod (1 + x)) <= 0 then (1 + x) else 0)
;; K K F C C C C C D D F J B K D H B K D A I
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= g1 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (f1 x) (* x x))))
(assert (forall ((x Int)) (= (f0 x) (* 2 (+ (+ x x) x)))))
(assert (= h1 (* 2 (+ 2 (+ 2 2)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int)) (= (small x) (ite (<= (modf (v0 x) (+ 1 x)) 0) (+ 1 x) 0))))
(assert (forall ((x Int)) (= (fast x) (ite (<= (modf v1 (+ 1 x)) 0) (+ 1 x) 0))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
