;; small program: ((1 - x) mod (1 + (loop (x * y) x 1)))
;; B K E B K L F K B J D H
;; fast program: ((loop (x * y) x 1) + ((loop 0 (2 - x) 2) - x))
;; K L F K B J A C K E C J K E D
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= f1 0))
(assert (= h0 1))
(assert (= h1 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) (- 2 x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* x y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (small x) (modf (- 1 x) (+ 1 (v0 x))))))
(assert (forall ((x Int)) (= (fast x) (+ (v0 x) (- (v1 x) x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) f1)) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f0 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
