;; small program: (2 div (loop ((x - 1) mod y) (x + x) 2))
;; C K B E L H K K D C J G
;; fast program: (if (loop ((loop ((x * x) * x) 1 (2 + 2)) mod (1 + x)) (x mod 2) x) <= 0 then (if x <= 0 then 1 else 2) else 0)
;; K K F K F B C C D J B K D H K C H K J K B C I A I
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 () Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g2 1))
(assert (= h0 2))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (g0 x) (+ x x))))
(assert (= h2 (+ 2 2)))
(assert (forall ((x Int)) (= (g1 x) (modf x 2))))
(assert (forall ((x Int)) (= (f2 x) (* (* x x) x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (modf (- x 1) y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (= v2 (u2 g2 h2)))
(assert (forall ((x Int)) (= (small x) (divf 2 (v0 x)))))
(assert (forall ((x Int)) (= (f1 x) (modf v2 (+ 1 x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (ite (<= (v1 x) 0) (ite (<= x 0) 1 2) 0))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
