;; small program: ((loop ((2 * (x + x)) + x) x 1) mod (1 + (loop (x * x) 2 2)))
;; C K K D F K D K B J B K K F C C J D H
;; fast program: (loop ((loop ((x + x) + x) (x mod (2 * (2 * (2 + 2)))) 1) mod (1 + (2 * (2 * (2 + 2))))) 1 ((2 * (x + x)) + x))
;; K K D K D K C C C C D F F H B J B C C C C D F F D H B C K K D F K D J
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun f3 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun g2 () Int)
(declare-fun g3 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 (Int) Int)
(declare-fun h3 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g2 1))
(assert (= h0 1))
(assert (= h3 1))
(assert (= g1 2))
(assert (= h1 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (f1 x) (* x x))))
(assert (forall ((x Int)) (= (f3 x) (+ (+ x x) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int)) (= (f0 x) (+ (* 2 (+ x x)) x))))
(assert (forall ((x Int)) (= (h2 x) (+ (* 2 (+ x x)) x))))
(assert (forall ((x Int)) (= (g3 x) (modf x (* 2 (* 2 (+ 2 2)))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y))))))
(assert (forall ((x Int)) (= (v3 x) (u3 (g3 x) h3))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) (+ 1 v1)))))
(assert (forall ((x Int)) (= (f2 x) (modf (v3 x) (+ 1 (* 2 (* 2 (+ 2 2))))))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 g2 (h2 x)))))
(assert (forall ((x Int)) (= (fast x) (v2 x))))
(assert (=> (forall ((x Int)) (= (f1 x) (f2 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u2 x y)))))
(assert (=> (forall ((x Int)) (= (f1 x) (f3 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u3 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f3 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u3 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
