;; small program: ((loop ((if (x * x) <= 0 then 1 else x) - y) (x + x) x) mod 2)
;; K K F B K I L E K K D K J C H
;; fast program: (if ((1 + (loop (x - (if x <= 0 then 0 else y)) (loop (x * x) 2 2) x)) * x) <= 0 then 0 else 1)
;; B K K A L I E K K F C C J K J D K F A B I
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun g2 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g2 2))
(assert (= h2 2))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (g0 x) (+ x x))))
(assert (forall ((x Int)) (= (f2 x) (* x x))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (- x (ite (<= x 0) 0 y)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (= v2 (u2 g2 h2)))
(assert (= g1 v2))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (- (ite (<= (* x x) 0) 1 x) y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 g1 (h1 x)))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) 2))))
(assert (forall ((x Int)) (= (fast x) (ite (<= (* (+ 1 (v1 x)) x) 0) 0 1))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
