;; small program: ((loop ((x * x) * x) 1 (x * x)) mod (loop (x * (2 + (2 + (2 + x)))) 2 1))
;; K K F K F B K K F J K C C C K D D D F C B J H
;; fast program: ((loop ((x * x) * x) 1 (x * x)) mod (1 + (loop ((1 + x) * (2 + x)) 1 (2 * (2 + 2)))))
;; K K F K F B K K F J B B K D C K D F B C C C D F J D H
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun g2 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(declare-fun v2 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 1))
(assert (= g2 1))
(assert (= h1 1))
(assert (= g1 2))
(assert (forall ((x Int)) (= (h0 x) (* x x))))
(assert (forall ((x Int)) (= (f0 x) (* (* x x) x))))
(assert (= h2 (* 2 (+ 2 2))))
(assert (forall ((x Int)) (= (f2 x) (* (+ 1 x) (+ 2 x)))))
(assert (forall ((x Int)) (= (f1 x) (* x (+ 2 (+ 2 (+ 2 x)))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (= v2 (u2 g2 h2)))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) v1))))
(assert (forall ((x Int)) (= (fast x) (modf (v0 x) (+ 1 v2)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (=> (forall ((x Int)) (= (f1 x) (f2 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u2 x y)))))
(assert (=> (forall ((x Int)) (= (f1 x) (f0 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f0 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
